﻿SuperStrict

Import "gfx/blitz.o"


' ----------------------------------------------------------------------------
' imported modules
' ----------------------------------------------------------------------------
Framework brl.basic
Import brl.d3d7max2d
'Import brl.glmax2d

Import brl.Pixmap
Import brl.event
Import brl.EventQueue
Import brl.filesystem
Import brl.FreeTypeFont
Import brl.map
Import brl.pngloader
Import brl.jpgloader
Import brl.oggloader
Import brl.retro
Import brl.DirectSoundAudio
Import brl.timer

Import maxgui.Drivers
Import maxgui.proxygadgets

Import bah.RegEx
Import bah.DBSQLite

Const MOD_ALT:Int = $0001
Const MOD_CONTROL:Int = $0002
Const MOD_NOREPEAT:Int = $4000
Const MOD_SHIFT:Int = $0004
Const MOD_WIN:Int = $0008
Const PRESSKEY:Int = $50  ' $50 = "P"
Const GWL_WNDPROC:Int = -4

Local RegisterHotkey:Int (hWnd:Int, id:Int, fsModifiers:Int, vk:Int) "win32"
Local user32:Int = LoadLibraryA ("user32.dll")
If user32 Then RegisterHotkey = GetProcAddress (user32, "RegisterHotKey")

'GLShareContexts()

' ----------------------------------------------------------------------------
' Source includes
' ----------------------------------------------------------------------------
Include "inc/Config.bmx"
Include "inc/Functions.bmx"
Include "inc/GUI.bmx"
Include "inc/Samples.bmx"
Include "inc/TBeat.bmx"
Include "inc/TBody.bmx"
Include "inc/TConfig.bmx"
Include "inc/TCalendar.bmx"
Include "inc/TSample.bmx"
Include "inc/TInfotext.bmx"
Include "inc/Win32.bmx"

' ----------------------------------------------------------------------------
' Application title and version
' ----------------------------------------------------------------------------
Const title:String = "Explorer Scan Assistant"
Const Version:String = "(beta 6b - 24.03.2025)"

' ----------------------------------------------------------------------------
' Global Variables
' ----------------------------------------------------------------------------

' default path and size
Global path:String = getenv_("USERPROFILE") + "\Saved Games\Frontier Developments\Elite Dangerous\"
Global width:Int = 1024
Global Height:Int = 576

' window size
Global cx:Int
Global cy:Int
Global cw:Int
Global ch:Int
Global as:Double
Global dx:Float
Global dy:Float

' config flags
Global Debug:Int = True
Global ontop:Int = 0
Global warnflag:Int = True
Global starflag:Int = True
Global planflag:Int = True
Global scanflag:Int = True
Global blipflag:Int = True
Global scooflag:Int = True
Global sampflag:Int = True
Global cashflag:Int = True
Global precflag:Int = True
Global hornflag:Int = True
Global modeflag:Int = False
Global tabsflag:Int = 0
Global saveflag:Int = True
Global timecorrection:Int=-99
Global monitorinterval:Int
Global pinginterval:Int
Global configdate1:String = 0
Global configdate2:String = 0
Global voicepath:String = "voice"

Global reward_class_y:Int
Global reward_class_t:Int
Global reward_class_l:Int
Global reward_class_tts:Int
Global reward_class_m:Int
Global reward_class_k:Int
Global reward_class_g:Int
Global reward_class_f:Int
Global reward_class_a:Int
Global reward_class_b:Int
Global reward_class_o:Int
Global reward_class_n:Int
Global reward_class_d:Int
Global reward_class_h:Int
Global reward_class_c:Int
Global reward_class_w:Int
Global reward_class_x:Int
Global reward_giant:Int
Global reward_supergiant:Int
Global reward_earthlike:Int
Global reward_waterworld:Int
Global reward_waterworld_terra:Int
Global reward_hmc:Int
Global reward_hmc_terra:Int
Global reward_metalrich:Int
Global reward_ammonia:Int
Global reward_rocky_terra:Int
Global reward_gas1:Int
Global reward_gas2:Int
Global reward_gas3:Int
Global reward_gas4:Int
Global reward_gas5:Int
Global reward_gas_ammonia:Int
Global reward_gas_water:Int
Global reward_gas_helium:Int
Global reward_gas_watergiant:Int
Global reward_rocky:Int
Global reward_icy:Int
Global reward_rockyicy:Int
Global reward_clusterbelt:Int

' get current UNIX timestamp
Global today:String = CurrentUnixTimestamp()

' Constants (fix)
Const MENU_EXIT:Int = 1
Const MENU_BROWSE:Int = 2
Const MENU_ABOUT:Int = 3
Const MENU_SAVE:Int = 4
Const MENU_ONTOP:Int = 5
Const MENU_EXPORT:Int = 6
Const MENU_FULLMODE:Int = 7
Const MENU_COMPACTMODE:Int = 8
Const MENU_SCREENSHOT:Int = 9
Const MENU_SAVEEXIT:Int = 10
Const MENU_IMPORT:Int = 11

Const MENU_SCAN:Int = 100

' TIME Constants in Seconds
Const ONEYEAR:Int = 60 * 60 * 24 * 365.25	' 31.536.000 seconds (ca.)
Const ONEMONTH:Int = 60 * 60 * 24 * 30		' 2.592.000 seconds (ca.)
Const ONEWEEK:Int = 60 * 60 * 24 * 7		' 604.800 seconds
Const ONEDAY:Int = 60 * 60 * 24				' 86.400 seconds
Const ONEHOUR:Int = 60 * 60					' 3.600 seconds
Const ONEMINUTE:Int = 60					' 60 seconds

' TInfo output
Global info:TInfo = New TInfo

' Globals
Global oldline:String
Global filedatemax:Int
Global sysid:Int

' Monitor
Global activity:String[] = ["o----", "-o---", "--o--", "---o-", "----o", "---o-", "--o--", "-o---"]
Global counter:Int = 1
Global statustext:String

' Parser
Global logfile:String
Global currentlogfile:String = ""

' Flags
Global Init:Int = True
Global initline:Int = True
Global volumeflag:Int

' Timing
Global timer:TTimer = CreateTimer(1)
Global monitortimer:TTimer = CreateTimer(10)
Global bliptimer:TTimer = CreateTimer(10)
Global updatetimer:TTimer = CreateTimer(10)
Global gltimer:TTimer = CreateTimer(60)
Global clicktimer:TTimer = CreateTimer(20)
Global ms:Int

' Samples
Global sample:TSample
Global samplelist:TList = CreateList()
Global channel:TChannel
Global channelvolume:Int = 50

' Current CMDR, Rank and Progress
Global currentcmdrstring:String
Global currentrankstring:String
Global currentprogstring:String
Global cmdr:String
Global ship:String
Global shipname:String
Global credits:Long

' Body evaluation
Global body:TBody
Global bodycount:TBodyCount = New TBodycount
Global bodylist:TList = CreateList()

' Lists and Maps
Global systemlist:TList = CreateList()
Global systemvisits:TMap = CreateMap()
Global systemcache:TMap = CreateMap()
Global analysislist:TList = CreateList()

' GUI clicks
Global click:TClick = New TClick
Global clicklist:TList = CreateList()

' MAXGUI
Global OldWindowFunc:Int

' MAXGUI: main frames
Global Window:TGadget
Global canvas:TGadget
Global statistics:TGadget
Global analysis:TGadget
Global LogDebug:TGadget

' MAXGUI: menus
Global filemenu:TGadget
Global scanmenu:TGadget
Global aboutmenu:TGadget
Global optionsmenu:TGadget

' MAXGUI: Progress bar
Global progress:TGadget

' MAXGUI: Tabs
Global tab:TGadget[4]
Global tabs:TGadget
Global currenttab:TGadget

' MAXGUI: Calendar
'Global cal1canvas:TGadget
'Global cal2canvas:TGadget
Global calflag:Int

' MAXGUI: Buttons
Global statbutton1:TGadget
Global statbutton2:TGadget
Global scanbutton:TGadget
Global blipbutton:TGadget
Global scoobutton:TGadget
Global warnbutton:TGadget
Global starbutton:TGadget
Global planbutton:TGadget
Global cashbutton:TGadget
Global precbutton:TGadget
Global hornbutton:TGadget
Global modebutton1:TGadget
Global modebutton2:TGadget
Global sam1button:TGadget
Global sam2button:TGadget
Global screenbutton:TGadget

' MAXGUI: Menu Gadget
Global ontopmenu:TGadget

' MAXGUI: other Gadgets
Global volume:TGadget
Global time:TGadget

' MAXGUI: 3D
'Global cam:TCamera
'Global mesh:TMesh
'Global light:TLight

' Timelimits
Global timerange:Int = 4
Global timeline:String[] = ["Scan Range: All", "Scan Range: Custom", "Scan Range: 1 Year", "Scan Range: 6 Months", "Scan Range: 1 Month", "Scan Range: 1 Week", "Scan Range: 48 Hours", "Scan Range: 24 Hours", "Scan Range: 12 Hours", "Scan Range: 6 Hours", "Scan Range: 1 Hour"]
Global times:Int[] = [(Int(Right(CurrentDate(), 4)) - 2016) * ONEYEAR, -1, 1 * ONEYEAR, 6 * ONEMONTH, 1 * ONEMONTH, 1 * ONEWEEK, 2 * ONEDAY, 1 * ONEDAY, 12 * ONEHOUR, 6 * ONEHOUR, 1 * ONEHOUR]
Global timemenu:TGadget[timeline.Length + 1]

' Config
Global config:TConfig = New TConfig
Global configfile:TStream = OpenFile(title + ".ini")
Global configmenu:TGadget
ReadConfigFile()

Global freq:TBeat = New TBeat.Create (monitorinterval, Freqprocess)
Global ping:TBeat = New TBeat.Create (pinginterval, Pingprocess)

' set current timelimit
Global timelimit:Int = times[timerange]

' Calendar
Global months:String[] = ["", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
Global cal1:TCalendar = New TCalendar
Global cal2:TCalendar = New TCalendar

' get current timestamp in UNIX format
Local curdate:String = FTimestamp(GetTimeStamp(), "%d%m%Y")
cal1.dd = Int(Mid(curdate, 1, 2))
cal1.mm = Int(Mid(curdate, 3, 2))
cal1.yy = Int(Mid(curdate, 5, 4))
cal2.dd = cal1.dd
cal2.mm = cal1.mm
cal2.yy = cal1.yy

If Int(configdate1) > 0 And Int(configdate2) > 0 Then

	Local dd1:Int = Int(Mid(configdate1, 1, 2))
	Local mm1:Int = Int(Mid(configdate1, 4, 2))
	Local yy1:Int = Int(Mid(configdate1, 7, 4))
	
	Local dd2:Int = Int(Mid(configdate2, 1, 2))
	Local mm2:Int = Int(Mid(configdate2, 4, 2))
	Local yy2:Int = Int(Mid(configdate2, 7, 4))
	
	dd1 = CheckINT(dd1, 1, 31, 0)
	mm1 = CheckINT(mm1, 1, 12, 0)
	yy1 = CheckINT(yy1, 1900, 3000, 0)
		
	dd2 = CheckINT(dd2, 1, 31, 0)
	mm2 = CheckINT(mm2, 1, 12, 0)
	yy2 = CheckINT(yy2, 1900, 3000, 0)

	'Print configdate1 + "|" + configdate2
	'Print dd1 + "#" + mm1 + "#" + yy1 + " " + dd2 + "#" + mm2 + "#" + yy2
	
	If dd1 <> 0 And mm1 <> 0 And yy1 <> 0 And dd2 <> 0 And mm2 <> 0 And yy2 <> 0 Then
	
		cal1.dd = dd1
		cal1.mm = mm1
		cal1.yy = yy1
		
		cal2.dd = dd2
		cal2.mm = mm2
		cal2.yy = yy2
	
	End If

End If

Global datefrom:Int = cal1.GetUnixTimestamp(cal1.yy, cal1.mm, cal1.dd, 0, 0, 0)
Global dateto:Int = cal1.GetUnixTimestamp(cal1.yy, cal1.mm, cal1.dd, 0, 0, 0) + 86400

' database connection
Global db:TDBConnection
Global sql:TDBSQLite
Global q:String

' Mouse
Global MouseWheel:Int
Global MouseButtonDown:Int
Global MouseButtonUp:Int
Global MouseSource:String
Global MX:Int, MY:Int

' Test
'Global ss:Float

' ----------------------------------------------------------------------------
' Include binaries
' ----------------------------------------------------------------------------
rem
Incbin "gfx/splash.png"
IncBin "gfx/splash_compact.png"
IncBin "gfx/stats.png"
IncBin "gfx/stats_compact.png"
IncBin "gfx/iconstrip.png"
IncBin "font/NovaMono.otf"

IncBin "sound/blip1.ogg"
IncBin "sound/blip2.ogg"
IncBin "sound/blip3.ogg"
Incbin "sound/work.ogg"
IncBin "sound/finish.ogg"
IncBin "sound/cash.ogg"
IncBin "sound/drum.ogg"
Incbin "sound/horn.ogg"
IncBin "sound/whoo.ogg"
IncBin "sound/water.ogg"
IncBin "sound/ammonia.ogg"
IncBin "sound/anvil.ogg"

IncBin voicepath+"/Ammoniaworld.ogg"
IncBin voicepath+"/Belt Cluster.ogg"
Incbin voicepath+"/Black Hole.ogg"
IncBin voicepath+"/Carbon Star.ogg"
IncBin voicepath+"/Class 1 Jovian.ogg"
IncBin voicepath+"/Class 2 Water Clouds.ogg"
IncBin voicepath+"/Class 3 Cloudless.ogg"
IncBin voicepath+"/Class 4 Alkali Metals.ogg"
IncBin voicepath+"/Class 5 Silicate Clouds.ogg"
IncBin voicepath+"/Commander this is a precious planet.ogg"
IncBin voicepath+"/Commander this is a very precious planet.ogg"
IncBin voicepath+"/Earthlike.ogg"
IncBin voicepath+"/Exotic Star.ogg"
IncBin voicepath+"/Giant.ogg"
Incbin voicepath+"/Helium Rich.ogg"
IncBin voicepath+"/High Metal Content.ogg"
IncBin voicepath+"/Icy.ogg"
IncBin voicepath+"/Metal Rich.ogg"
IncBin voicepath+"/Neutron Star.ogg"
IncBin voicepath+"/Rocky Icy.ogg"
IncBin voicepath+"/Rocky.ogg"
IncBin voicepath+"/Scan completed.ogg"
IncBin voicepath+"/Star Class A.ogg"
IncBin voicepath+"/Star Class B.ogg"
IncBin voicepath+"/Star Class F.ogg"
IncBin voicepath+"/Star Class G.ogg"
IncBin voicepath+"/Star Class K.ogg"
IncBin voicepath+"/Star Class L.ogg"
IncBin voicepath+"/Star Class M.ogg"
IncBin voicepath+"/Star Class O.ogg"
IncBin voicepath+"/Star Class T.ogg"
IncBin voicepath+"/Star Class TTS.ogg"
IncBin voicepath+"/Star Class Y.ogg"
IncBin voicepath+"/Sudarski Gas Giant.ogg"
IncBin voicepath+"/Super Giant.ogg"
IncBin voicepath+"/Terraformable.ogg"
IncBin voicepath+"/Water Giant.ogg"
IncBin voicepath+"/Waterworld.ogg"
IncBin voicepath+"/Welcome Commander.ogg"
IncBin voicepath+"/White Dwarf.ogg"
IncBin voicepath+"/With Ammonia-based life.ogg"
IncBin voicepath+"/With Water-based life.ogg"
IncBin voicepath+"/Wolf-Rayet Star.ogg"
IncBin voicepath+"/Scoopable.ogg"
IncBin voicepath+"/Extreme radiation detected.ogg"
IncBin voicepath+"/Extreme gravity detected.ogg"
IncBin voicepath+"/Extreme heat detected.ogg"
IncBin voicepath+"/Danger.ogg"
IncBin voicepath+"/Be careful.ogg"
IncBin voicepath+"/This is a very rare stellar object.ogg"
IncBin voicepath+"/Gas Giant.ogg"
IncBin voicepath+"/Main Sequence.ogg"
IncBin voicepath+"/Brown Dwarf Star.ogg"
IncBin voicepath+"/Not Scoopable.ogg"
IncBin voicepath+"/Protostar.ogg"
IncBin voicepath+"/Warning.ogg"
endrem

' ----------------------------------------------------------------------------
' Load included assets from executable
' ----------------------------------------------------------------------------
Global image:TImage = LoadImage("gfx/splash.png")
Global image_compact:TImage = LoadImage("gfx/splash_compact.png")
Global image_stats:TImage = LoadImage("gfx/stats.png")
Global image_stats_compact:TImage = LoadImage("gfx/stats_compact.png")
Global icons:TIconStrip = LoadIconStrip("gfx/iconstrip.png")

Global soundblip1:TSound = LoadSound("sound/blip1.ogg")
Global soundblip2:TSound = LoadSound("sound/blip2.ogg")
Global soundblip3:TSound = LoadSound("sound/blip3.ogg")
Global soundcash:TSound = LoadSound("sound/cash.ogg")
Global sounddrum:TSound = LoadSound("sound/drum.ogg")
Global soundhorn:TSound = LoadSound("sound/horn.ogg")
Global soundwhoo:TSound = LoadSound("sound/whoo.ogg")
Global soundwater:TSound = LoadSound("sound/water.ogg")
Global soundammonia:TSound = LoadSound("sound/ammonia.ogg")
Global soundanvil:TSound = LoadSound("sound/anvil.ogg")
Global soundwork:TSound = LoadSound("sound/work.ogg", SOUND_LOOP)
Global soundfinish:TSound = LoadSound("sound/finish.ogg")

Global voiceammonia:TSound = LoadSound(voicepath+"/Ammoniaworld.ogg")
Global voicebelt:TSound = LoadSound(voicepath+"/Belt Cluster.ogg")
Global voiceblackhole:TSound = LoadSound(voicepath+"/Black Hole.ogg")
Global voicecarbonstar:TSound = LoadSound(voicepath+"/Carbon Star.ogg")
Global voiceclass1:TSound = LoadSound(voicepath+"/Class 1 Jovian.ogg")
Global voiceclass2:TSound = LoadSound(voicepath+"/Class 2 Water Clouds.ogg")
Global voiceclass3:TSound = LoadSound(voicepath+"/Class 3 Cloudless.ogg")
Global voiceclass4:TSound = LoadSound(voicepath+"/Class 4 Alkali Metals.ogg")
Global voiceclass5:TSound = LoadSound(voicepath+"/Class 5 Silicate Clouds.ogg")
Global voicepreciousplanet:TSound = LoadSound(voicepath+"/Commander this is a precious planet.ogg")
Global voiceverypreciousplanet:TSound = LoadSound(voicepath+"/Commander this is a very precious planet.ogg")
Global voiceearthlike:TSound = LoadSound(voicepath+"/Earthlike.ogg")
Global voiceexoticstar:TSound = LoadSound(voicepath+"/Exotic Star.ogg")
Global voicegiant:TSound = LoadSound(voicepath+"/Giant.ogg")
Global voiceheliumrich:TSound = LoadSound(voicepath+"/Helium Rich.ogg")
Global voicehighmetalcontent:TSound = LoadSound(voicepath+"/High Metal Content.ogg")
Global voiceicy:TSound = LoadSound(voicepath+"/Icy.ogg")
Global voicemetalrich:TSound = LoadSound(voicepath+"/Metal Rich.ogg")
Global voiceneutronstar:TSound = LoadSound(voicepath+"/Neutron Star.ogg")
Global voicerockyicy:TSound = LoadSound(voicepath+"/Rocky Icy.ogg")
Global voicerocky:TSound = LoadSound(voicepath+"/Rocky.ogg")
Global voicescancompleted:TSound = LoadSound(voicepath+"/Scan completed.ogg")
Global voicestara:TSound = LoadSound(voicepath+"/Star Class A.ogg")
Global voicestarb:TSound = LoadSound(voicepath+"/Star Class B.ogg")
Global voicestarf:TSound = LoadSound(voicepath+"/Star Class F.ogg")
Global voicestarg:TSound = LoadSound(voicepath+"/Star Class G.ogg")
Global voicestark:TSound = LoadSound(voicepath+"/Star Class K.ogg")
Global voicestarl:TSound = LoadSound(voicepath+"/Star Class L.ogg")
Global voicestarm:TSound = LoadSound(voicepath+"/Star Class M.ogg")
Global voicestaro:TSound = LoadSound(voicepath+"/Star Class O.ogg")
Global voicestart:TSound = LoadSound(voicepath+"/Star Class T.ogg")
Global voicestartts:TSound = LoadSound(voicepath+"/Star Class TTS.ogg")
Global voicestary:TSound = LoadSound(voicepath+"/Star Class Y.ogg")
Global voicesudarski:TSound = LoadSound(voicepath+"/Sudarski Gas Giant.ogg")
Global voicesupergiant:TSound = LoadSound(voicepath+"/Super Giant.ogg")
Global voiceterraformable:TSound = LoadSound(voicepath+"/Terraformable.ogg")
Global voicewatergiant:TSound = LoadSound(voicepath+"/Water Giant.ogg")
Global voicewaterworld:TSound = LoadSound(voicepath+"/Waterworld.ogg")
Global voicewelcome:TSound = LoadSound(voicepath+"/Welcome Commander.ogg")
Global voicewhitedwarf:TSound = LoadSound(voicepath+"/White Dwarf.ogg")
Global voicewithammonia:TSound = LoadSound(voicepath+"/With Ammonia-based life.ogg")
Global voicewithwater:TSound = LoadSound(voicepath+"/With Water-based life.ogg")
Global voicewolfrayetstar:TSound = LoadSound(voicepath+"/Wolf-Rayet Star.ogg")
Global voicescoopable:TSound = LoadSound(voicepath+"/Scoopable.ogg")
Global voiceextremeradiation:TSound = LoadSound(voicepath+"/Extreme radiation detected.ogg")
Global voiceextremegravity:TSound = LoadSound(voicepath+"/Extreme gravity detected.ogg")
Global voiceextremeheat:TSound = LoadSound(voicepath+"/Extreme heat detected.ogg")
Global voicedanger:TSound = LoadSound(voicepath+"/Danger.ogg")
Global voicebecareful:TSound = LoadSound(voicepath+"/Be careful.ogg")
Global voicerareobject:TSound = LoadSound(voicepath+"/This is a very rare stellar object.ogg")
Global voicegasgiant:TSound = LoadSound(voicepath+"/Gas Giant.ogg")
Global voicemainsequence:TSound = LoadSound(voicepath+"/Main Sequence.ogg")
Global voicebrowndwarf:TSound = LoadSound(voicepath+"/Brown Dwarf Star.ogg")
Global voicenotscoopable:TSound = LoadSound(voicepath+"/Not Scoopable.ogg")
Global voiceprotostar:TSound = LoadSound(voicepath+"/Protostar.ogg")
Global voicewarning:TSound = LoadSound(voicepath+"/Warning.ogg")

Global font:TImageFont = LoadImageFont("font/NovaMono.otf", 28, SMOOTHFONT)
Global fontlarge:TImageFont = LoadImageFont("font/NovaMono.otf", 60, SMOOTHFONT)
Global fontmid:TImageFont = LoadImageFont("font/NovaMono.otf", 40, SMOOTHFONT)
Global fontsmall:TImageFont = LoadImageFont("font/NovaMono.otf", 28, SMOOTHFONT)

' ----------------------------------------------------------------------------
' Initialize application
' ----------------------------------------------------------------------------
InitGUI()
ModeCheck()
UpdateGUI()
UpdateButtons()
channel = CueSound(soundblip1)
LogUpdate("Log started. Welcome to the Betatest Commander. I hope there are not too many bugs :-)")

Global OldWindowFuncKill:Int = SetWindowFunc(Window, WindowFuncKill)
RegisterHotkey (QueryGadget (Window, QUERY_HWND), 1, MOD_ALT, PRESSKEY)






AddHook EmitEventHook, LoopHook			' Second Hook: main loop

' ----------------------------------------------------------------------------
' Loop Hook
' ----------------------------------------------------------------------------
Function LoopHook:Object(id:Int, data:Object, context:Object)

	Local Event:TEvent = TEvent(data)
	If Event = Null Then Return Event
		
	Select Event.id

		Case EVENT_WINDOWCLOSE
								If saveflag Then WriteConfigFile()
								'db.close()
								End

		Case EVENT_APPTERMINATE
								If saveflag Then WriteConfigFile()
								'db.close()
								End

		Case EVENT_WINDOWSIZE
								' maintain window size
  								SetGadgetShape(Window, GadgetX(Window), GadgetY(Window), width + 24, Height + 110)

		Case EVENT_TIMERTICK
								If Init = True Then

									AddSample(70)
									AddSample(70)
									AddSample(70)
									AddSample(48) ' Welcome commander
									AddSample(70)
									AddSample(70)
									AddSample(70)
									AddSample(70)
									AddSample(8)
									
									Init = False
									statustext = "Please wait... loading"
									
								EndIf

								Select Event.Source
								
									Case timer
												counter:+1
												counter = counter Mod activity.Length

												SetStatusText(Window, statustext)

									Case bliptimer

												If volumeflag Then

													volumeflag = False
													If blipflag Then PlaySample(8) ' Blip 1

												EndIf
												
									Case monitortimer
				
												'' retrieve CMDR name
												'If currentlogfile <> "" Then TBody.InitCMDR()
												
												'TBody.Monitor()
												
									Case updatetimer

												RedrawGadget canvas
												RedrawGadget statistics
												
												RedrawGadget LogDebug
												
									Case gltimer
									
												RedrawGadget analysis
												
									Case clicktimer
									
												If saveflag Then CheckMenu(configmenu) Else UncheckMenu(configmenu)

												For Local c:TClick = EachIn clicklist
												
													c.Check(canvas)
												
												Next

								End Select

								PlaySampleQueue()
								
								GCCollect()

								Delay 1
								
		Case EVENT_GADGETPAINT

								Select Event.source
								
									Case canvas
												UpdateGUI()
												
									Case statistics
									
												UpdateStatistics()
												
									Case analysis
									
												UpdateAnalysis()
									
								End Select
								

		Case EVENT_MENUACTION

								Select Event.data

									Case MENU_EXIT
													'WriteConfigFile()
													End

									Case MENU_BROWSE

													If blipflag Then PlaySample(8)

													' file dialog window to select a custom journal directory
													Local newpath:String = RequestDir("Select Journal Logs Directory to monitor...", getenv_("USERPROFILE") + "\Saved Games\Frontier Developments\Elite Dangerous") + "\"
													
													LogUpdate("New Path selected: " + newpath)
													
													If newpath <> path And (newpath <> "\") Then
													
														path = newpath
														filedatemax = 0
														Init = True
														oldline = ""
														
														currentcmdrstring = ""
														currentrankstring = ""
														currentprogstring = ""
														
														TBody.Monitor()
														UpdateGUI()

														RedrawGadget canvas
														RedrawGadget statistics
														RedrawGadget analysis
														RedrawGadget LogDebug
														
													EndIf
													
									Case MENU_SAVE
													If blipflag Then PlaySample(8)
													If WriteConfigFile() Then Notify("Settings saved to " + title + ".ini") Else Notify("Error writing settings. Check if the file " + title + ".ini is either write-protected or if you have write access to the folder where you started this application from")
													
									Case MENU_SAVEEXIT
									
													saveflag = 1 - saveflag
													'Print "CHECKED"


									Case MENU_ABOUT
													' About informations
													If blipflag Then PlaySample(8)
													Notify(title + " " + Version + "~n" + "by Krischan www.extrasolar.de~nWritten in Blitzmax~n~nThis is a tiny tool for lazy explorers which adds a nice voice assistant. It monitors the game journal folder of the game Elite: Dangerous® in the background (once a second) and plays a sound when a Detail scan has been finished.~n~nIf a precious planet has been found, additional voice sounds are played, too. Precious Planets are: Earthlike, Waterworld, Ammonia World, Metal Rich. If the planet is an Earthlike or a Terraformable Waterworld or High Metal Content a notice that a *very* precious planet has been found is added.~n~nThe 'Scan' button scans the whole Journal folder for previously logged Detail Scans and displays the results per Class and adds all rewards together.~n~nSee ReadMe.txt file for more information.~n~nElite: Dangerous © 2012, 2013 Frontier Developments plc. All rights reserved.")
													
									Case MENU_ONTOP
									
													If blipflag Then PlaySample(8)
													
													ontop = 1 - ontop
												
													If ontop = 1 Then
													
														CheckMenu(ontopmenu)
														SetWindowTopMost(Window, True)
														
													Else
													
														UncheckMenu(ontopmenu)
														SetWindowTopMost(Window, False)
														
													EndIf
													
									Case MENU_EXPORT
																						
													Local filename:String = RequestFile("Select SQLite export filename...", "SQLite Files:db,sqlite,sqlite3;All Files:*", True, "CMDR " + cmdr)
									
													If filename Then
													
														Local rc:Int = loadOrSaveDB(sql, filename, True)
														
														If rc = 0 Then
														
															LogUpdate("Scan data exported to SQLite database " + filename, True)
														
															Notify("Scan data exported to SQLite database " + filename)
															
														Else
														
															LogUpdate("ERROR: Database " + filename + " could not be updated.")
															Notify("Database " + filename + " could not be updated. Please check if it is currently opened by a 3rd party tool or write-protected!")
															
														EndIf

													EndIf
													
									Case MENU_IMPORT
																						
													Local filename:String = RequestFile("Select SQLite import filename...", "SQLite Files:db,sqlite,sqlite3;All Files:*", False, "CMDR " + cmdr)
									
													If filename Then
													
														Local db:TDBConnection = LoadDatabase("SQLITE", filename)
														
														If TDBConnection(db) Then
														
															sql = TDBSQLite(db)
															
															' play scanner sound (looped)
															If blipflag Then PlaySample(9)
															TBody.Analize(db)
															StopChannel channel
															If blipflag Then AddSample(10)
															StopChannel channel
															
															LogUpdate("Scan data imported from SQLite database file " + filename, True)
														
															Notify("Scan data imported from SQLite database file " + filename)
															
														Else
														
															LogUpdate("ERROR: Database " + filename + " could not be loaded.")
															Notify("Database " + filename + " could not be loaded. Please check if it is currently opened by a 3rd party tool or corrupted!")
															
														EndIf

													EndIf													
													
									Case MENU_FULLMODE
									
													modeflag = 0
													
													UpdateGUI()
													UpdateStatistics()
													UpdateAnalysis()
													
													RedrawGadget canvas
													RedrawGadget statistics
													RedrawGadget analysis
													
													ModeCheck()
													
									Case MENU_COMPACTMODE
									
													modeflag = 1
													
													UpdateGUI()
													UpdateStatistics()
													UpdateAnalysis()
													
													RedrawGadget canvas
													RedrawGadget statistics
													RedrawGadget analysis
													
													ModeCheck()
													
									Case MENU_SCREENSHOT
									
													Screenshot()
									

								End Select

								' select Scan Time from Menu bar and update pulldown, too
								If Event.data >= MENU_SCAN And Event.data <= MENU_SCAN + timeline.Length Then

									If blipflag Then PlaySample(8)
								
									For Local i:Int = 0 To timeline.Length - 1

										UncheckMenu(timemenu[i])

									Next

									SelectGadgetItem(time, Event.data - MENU_SCAN)
									timerange = Event.Data - MENU_SCAN
									timelimit = times[timerange]
									
									calflag = 0
									If timelimit = -1 Then calflag = 1
									
									If Event.data - MENU_SCAN = timerange Then CheckMenu(timemenu[Event.data - MENU_SCAN])

									TBody.RescanFolder()
									'TBody.Monitor()
									EmitEvent(CreateEvent(EVENT_GADGETACTION, Tabs, 1, 0, 0, 0, tab[1]))
									SelectGadgetItem(tabs, 1)
									ShowGadget(tab[1])
																	
								EndIf

		Case EVENT_GADGETACTION

		
								' tab handling
								If Event.Source = tabs
								
									HideGadget currenttab
									currenttab = tab[Event.data]
									ShowGadget currenttab
									tabsflag = Event.data
									
									'Print Event.data
									
									TBody.Monitor()
									
									RedrawGadget canvas
									RedrawGadget statistics
									RedrawGadget analysis
									RedrawGadget LogDebug
									
									If blipflag Then PlaySample(8)
									
								EndIf

								' watch button click event
								Select Event.Source
								
									Case statbutton1, statbutton2

												Local date1:Int = cal1.GetUnixTimestamp(cal1.yy, cal1.mm, cal1.dd, 0, 0, 0)
												Local date2:Int = cal1.GetUnixTimestamp(cal2.yy, cal2.mm, cal2.dd, 0, 0, 0)
												
												If date1 > date2 Then
												
													datefrom = date2
													dateto = date1 + 86400
													
												Else
												
													datefrom = date1
													dateto = date2 + 86400
													
												EndIf
												
												'Print FTimestamp(date1) + "->" + FTimestamp(date2)
												'Print FTimestamp(datefrom) + "->" + FTimestamp(dateto)
									
												If blipflag Then PlaySample(8)
												TBody.RescanFolder()												
												RedrawGadget statistics
												RedrawGadget analysis
												EmitEvent(CreateEvent(EVENT_GADGETACTION, Tabs, 1, 0, 0, 0, tab[1]))
												SelectGadgetItem(Tabs, 1)
												ShowGadget(tab[1])
												
									Case scanbutton
									
												scanflag = 1 - scanflag
												If blipflag Then PlaySample(8)
												'TBody.Monitor()
												
												UpdateGUI()
												UpdateStatistics()
												UpdateAnalysis()
												RedrawGadget canvas
												RedrawGadget statistics
												RedrawGadget analysis
												UpdateButtons()
									
									Case blipbutton
									
												blipflag = 1 - blipflag
												If blipflag Then PlaySample(8)
												UpdateButtons()
									
									Case scoobutton
									
												scooflag = 1 - scooflag
												If blipflag Then PlaySample(8)
												UpdateButtons()
									
									Case warnbutton
									
												warnflag = 1 - warnflag
												If blipflag Then PlaySample(8)
												UpdateButtons()
									
									Case starbutton
									
												starflag = 1 - starflag
												If blipflag Then PlaySample(8)
												UpdateButtons()
									
									Case planbutton
									
												planflag = 1 - planflag
												If blipflag Then PlaySample(8)
												UpdateButtons()

									Case cashbutton
									
												cashflag = 1 - cashflag
												If blipflag Then PlaySample(8)
												UpdateButtons()

									Case precbutton
									
												precflag = 1 - precflag
												If blipflag Then PlaySample(8)
												UpdateButtons()

									Case hornbutton
									
												hornflag = 1 - hornflag
												If blipflag Then PlaySample(8)
												UpdateButtons()
												
									Case sam1button

												sampflag = 0
												If blipflag Then PlaySample(8)
												UpdateButtons()

									Case sam2button

												sampflag = 1
												If blipflag Then PlaySample(8)
												UpdateButtons()
												
									Case screenbutton
									
												Screenshot()

									Case time
												timerange = SelectedGadgetItem(time)
												timelimit = times[timerange]

												For Local i:Int = 0 To timeline.Length - 1
												
													If timerange = i Then CheckMenu(timemenu[i]) Else UncheckMenu(timemenu[i])

												Next
												
												calflag = 0
												If timelimit = -1 Then calflag = 1
						
												TBody.Monitor()
												
												UpdateGUI()
												UpdateStatistics()
												UpdateAnalysis()
												
												RedrawGadget canvas
												RedrawGadget statistics
												RedrawGadget analysis

												
												
									' volume slider
									Case volume
												channelvolume = SliderValue(volume)
												volumeflag = True
												
									Case modebutton1, modebutton2
									
												modeflag = 1 - modeflag
												
												TBody.Monitor()
												
												UpdateGUI()
												UpdateStatistics()
												UpdateAnalysis()
												
												RedrawGadget canvas
												RedrawGadget statistics
												RedrawGadget analysis
												
												ModeCheck()
												
								EndSelect
	
		Case EVENT_MOUSEDOWN
								MouseButtonDown = Event.data
								
		Case EVENT_MOUSEUP
								MouseButtonDown = 0
								MouseButtonUp = Event.data
								
		Case EVENT_MOUSEWHEEL
						
								If Event.data > 0 Then

									MouseWheel:+1
									If MouseWheel > 5 Then MouseWheel = 5

								Else

									MouseWheel:-1
									If MouseWheel < 1 Then MouseWheel = 1

								EndIf


		Case EVENT_MOUSEMOVE
								MX = Event.x
								MY = Event.y
								MouseSource = Event.toString()
								
	End Select

End Function

' ----------------------------------------------------------------------------
' Main Loop
' ----------------------------------------------------------------------------
Repeat

	WaitEvent()

Forever

End



' ------------------------------------------------------------------------------------------------
' Ping Sound Background process
' ------------------------------------------------------------------------------------------------
Function Pingprocess(Caller:TBeat, event:TEvent)

	AddSample(70)
	
End Function


' ------------------------------------------------------------------------------------------------
' Rescan Logfile Background Process
' ------------------------------------------------------------------------------------------------
Function Freqprocess(Caller:TBeat, event:TEvent)

	' retrieve CMDR name
	If currentlogfile <> "" And currentcmdrstring = "" And currentrankstring = "" And currentprogstring = "" Then
	
		TBody.InitCMDR()
			
	EndIf
	
	cmdr = RegFind(currentcmdrstring, "~qCommander~q:~q(.*?)~q,")
	ship = RegFind(currentcmdrstring, "~qShip~q:~q(.*?)~q,")
	shipname = RegFind(currentcmdrstring, "~qShipname~q:~q(.*?)~q,")
	credits = Long(RegFind(currentcmdrstring, "~qCredits~q:(.*?),"))
	
	TBody.Monitor()
	
	RedrawGadget canvas
	RedrawGadget statistics
	RedrawGadget analysis
	RedrawGadget LogDebug
	
	statustext = activity[counter] + " Monitoring Logfile: " + currentlogfile
				
End Function

' ------------------------------------------------------------------------------------------------
' secret Taskkiller option
' ------------------------------------------------------------------------------------------------
Function WindowFuncKill:Int(hwnd:Int, MSG:Int, wparam:Int, lparam:Int) "Win32"

	Select MSG
	
		Case WM_HOTKEY
								system_("taskkill /f /im EliteDangerous32.exe")
								system_("taskkill /f /im EliteDangerous64.exe")
								Notify "Elite Dangerous Process killed!"
			
		Case WM_DESTROY
								SetWindowLong(hwnd, GWL_WNDPROC, OldWindowFuncKill)
			
	End Select

	Return CallWindowProc(OldWindowFuncKill, hwnd, MSG, wparam, Int(lparam))

End Function

Function SetWindowFuncKill:Int(Window:TGadget, newfunc:Int(hwnd:Int, MSG:Int, wparam:Int, lparam:Int))
	
	Local hwnd:Int = QueryGadget(Window, QUERY_HWND)
	Local oldfunc:Int = GetWindowLong(hwnd, GWL_WNDPROC)
	
	SetWindowLong(hwnd, GWL_WNDPROC, Int(Byte Ptr newfunc))
	
	Return oldfunc
	
End Function